from typing import Any, List, Dict
from pipelines.prompta.utils import query2str, show_graph, str2bool, json_keys
from .rule_based_oracle import RuleBasedOracle


class ExpertOracle(RuleBasedOracle):

    def check_conjecture(self, aut, _type=str):
        print("check")
        show_aut = input("Do you want to see the current automaton? Y/N: ")
        show_aut = 'y' in show_aut.lower()
        if show_aut:
            print(f"Current task: {self.language.context_name}")
            print(f"Definition: {self.language.definition}")
            show_graph(aut, disable_graphics=True)
        counterexample = input("Please enter a counter example: ")
        if counterexample.lower() == 'none':
            return None
        return counterexample
